/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.builder.ramdisk.nodejs;

import com.boxfuse.base.coordinates.AppName;
import com.boxfuse.base.payload.PayloadEntry;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.types.Pair;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.base.util.ZipUtils;
import com.boxfuse.generator.builder.ramdisk.RamDisk;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsConfig;
import com.boxfuse.generator.builder.ramdisk.nodejs.NodeJsPayload;
import com.boxfuse.generator.payload.FilePayload;
import com.boxfuse.generator.payload.PayloadFormat;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsTgzPayload
extends FilePayload
implements NodeJsPayload {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJsTgzPayload.class);
    private static final String PACKAGE_JSON = "package/package.json";
    private static final String NPM_SHRINKWRAP_JSON = "package/npm-shrinkwrap.json";
    private static final String SYSCTL_CONF = "package/sysctl.conf";
    private final NodeJsConfig nodeJsConfig;

    public static boolean supports(String name, PayloadFormat format, Map<String, PayloadEntry> entries, boolean live) {
        return name.endsWith(".tgz") && PayloadFormat.TARGZ == format && entries.keySet().contains(PACKAGE_JSON) && !live;
    }

    public NodeJsTgzPayload(File file, byte[] bytes, Map<String, PayloadEntry> entries) {
        super(file, bytes, entries);
        Map files = ZipUtils.untarGzEntriesToByteArrays((byte[])bytes, (String[])new String[]{PACKAGE_JSON, NPM_SHRINKWRAP_JSON});
        String packageJson = StringUtils.toUtf8String((byte[])((byte[])files.get(PACKAGE_JSON)));
        String npmShrinkwrapJson = StringUtils.toUtf8String((byte[])((byte[])files.get(NPM_SHRINKWRAP_JSON)));
        this.nodeJsConfig = new NodeJsConfig(packageJson, npmShrinkwrapJson);
    }

    @Override
    public PayloadType getType() {
        return PayloadType.NODEJS;
    }

    @Override
    public String getNodeExecutable() {
        return "node";
    }

    @Override
    public NodeJsConfig getNodeJsConfig() {
        return this.nodeJsConfig;
    }

    @Override
    public Pair<String, byte[]> getSysCtlConf() {
        if (this.entries.keySet().contains(SYSCTL_CONF)) {
            return Pair.of((Object)SYSCTL_CONF, null);
        }
        return null;
    }

    @Override
    public void installInto(RamDisk ramDisk, String baseDir) throws IOException {
        ramDisk.installTarGzArchive(this.bytes, baseDir, "package", true);
    }

    @Override
    public AppName extractAppName() {
        AppName name = this.nodeJsConfig.getName();
        if (name != null) {
            return name;
        }
        return super.extractAppName();
    }

    @Override
    public Version extractVersion(boolean fallback) {
        Version version = this.nodeJsConfig.getVersion();
        if (version != null) {
            LOGGER.debug("Detected version in package.json: " + version);
            return version;
        }
        return super.extractVersion(fallback);
    }
}

