/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.image;

import com.boxfuse.base.coordinates.AppCoordinates;
import com.boxfuse.base.coordinates.ImageCoordinates;
import com.boxfuse.base.coordinates.Owner;
import com.boxfuse.base.enums.AppType;
import com.boxfuse.base.enums.DbType;
import com.boxfuse.base.enums.LogsType;
import com.boxfuse.base.enums.PlatformType;
import com.boxfuse.base.enums.TlsType;
import com.boxfuse.base.env.EnvVarName;
import com.boxfuse.base.env.EnvVarValue;
import com.boxfuse.base.exception.BoxfuseException;
import com.boxfuse.base.payload.PayloadType;
import com.boxfuse.base.port.Port;
import com.boxfuse.base.port.PortName;
import com.boxfuse.base.port.Protocol;
import com.boxfuse.base.port.Restriction;
import com.boxfuse.base.types.ComponentId;
import com.boxfuse.base.types.HealthcheckTimeout;
import com.boxfuse.base.types.Path;
import com.boxfuse.base.types.TmpGB;
import com.boxfuse.base.types.Version;
import com.boxfuse.base.util.CollectionUtils;
import com.boxfuse.base.util.StringUtils;
import com.boxfuse.generator.config.BoxfuseConfig;
import com.boxfuse.generator.image.AbstractJvmSpec;
import com.boxfuse.generator.image.spec.ImageSpec;
import com.boxfuse.generator.image.spec.JvmSpec;
import com.boxfuse.generator.newrelic.NewRelicLicenseKey;
import com.boxfuse.generator.payload.Payload;
import com.boxfuse.generator.payload.PayloadFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSpecImpl
implements ImageSpec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageSpecImpl.class);
    private final PlatformType[] platforms;
    private final Payload payload;
    private final BoxfuseConfig config;
    private final boolean live;
    private NewRelicLicenseKey newRelicLicenseKey;
    private AppType appType;
    private DbType dbType;
    private LogsType logsType;
    private TlsType tlsType;
    private ImageCoordinates imageCoordinates;
    private final Map<PortName, Port> ports = new HashMap<PortName, Port>();
    private PortName payloadPort;
    private Path payloadPath;
    private boolean healthcheck;
    private PortName healthcheckPort;
    private Path healthcheckPath;
    private final Map<EnvVarName, EnvVarValue> envVars = new TreeMap<EnvVarName, EnvVarValue>();

    public NewRelicLicenseKey getNewRelicLicenseKey() {
        return this.newRelicLicenseKey;
    }

    public ImageSpecImpl(Owner owner, BoxfuseConfig config) {
        this(owner, config, true);
    }

    ImageSpecImpl(Owner owner, BoxfuseConfig config, boolean resolvePayload) {
        PlatformType[] platformTypeArray;
        this.config = config;
        this.live = config.live.get();
        if (this.live) {
            PlatformType[] platformTypeArray2 = new PlatformType[2];
            platformTypeArray2[0] = PlatformType.VIRTUALBOX;
            platformTypeArray = platformTypeArray2;
            platformTypeArray2[1] = PlatformType.HYPERV;
        } else {
            PlatformType[] platformTypeArray3 = new PlatformType[3];
            platformTypeArray3[0] = PlatformType.VIRTUALBOX;
            platformTypeArray3[1] = PlatformType.HYPERV;
            platformTypeArray = platformTypeArray3;
            platformTypeArray3[2] = PlatformType.AWS;
        }
        this.platforms = platformTypeArray;
        if (resolvePayload) {
            this.payload = this.resolvePayload(config);
            if (config.image.isSet()) {
                this.imageCoordinates = config.image.get();
            } else {
                AppCoordinates appCoordinates = config.app.get();
                if (appCoordinates == null) {
                    appCoordinates = new AppCoordinates(owner, this.payload.extractAppName());
                }
                Version version = this.payload.extractVersion(false);
                this.imageCoordinates = new ImageCoordinates(appCoordinates, version);
            }
        } else {
            this.payload = null;
        }
        this.setAppType(config.appType.getConfigured());
        this.setDbType(config.dbType.getConfigured());
        this.setTlsType(config.tlsType.getConfigured());
        this.setLogsType(config.logs.type.getConfigured());
        this.configurePorts();
        this.configurePayloadPort();
        this.setPayloadPath(config.payload.path.getConfigured());
        this.healthcheck = config.healthcheck.enabled.get();
        this.configureHealthcheckPort();
        this.setHealthcheckPath(config.healthcheck.path.getConfigured());
        this.envVars.putAll(config.envvars);
        this.newRelicLicenseKey = config.newrelicLicensekey.get();
    }

    private Payload resolvePayload(BoxfuseConfig config) {
        String payloadLocation = config.payload.location.get();
        if (payloadLocation != null) {
            LOGGER.debug("Using Payload: " + payloadLocation);
            return PayloadFactory.toPayload(payloadLocation, this.live);
        }
        String payloadSearchDir = config.payload.searchDir.get();
        Payload payloadFound = PayloadFactory.findFirstPayload(new File(payloadSearchDir), this.live);
        if (payloadFound != null) {
            return payloadFound;
        }
        if (config.image.isSet()) {
            throw new BoxfuseException("Unknown image: " + config.image.get() + " => use ls to list available ones");
        }
        throw new BoxfuseException("No payload specified and no payloads found in the current directory\n=> ensure it contains at least one of these payloads types: " + StringUtils.arrayToDelimitedString((Object[])PayloadType.values(), (String)", ") + "\n=> alternatively specify the payload explicitly" + (this.live ? "\n=> ensure the live payload is a directory or fuse a regular image instead" : ""));
    }

    private void configurePorts() {
        Map portDuplicates;
        this.ports.putAll(this.config.ports);
        if (this.isDebug() && !this.ports.containsKey(PortName.DEBUG)) {
            this.ports.put(PortName.DEBUG, Port.of((int)5005, (Protocol)Protocol.TCP, (Restriction)Restriction.OWN_IP));
        }
        if (this.getJvm().isJmx() && !this.ports.containsKey(PortName.JMX)) {
            this.ports.put(PortName.JMX, Port.of((int)1099, (Protocol)Protocol.TCP, (Restriction)Restriction.OWN_IP));
        }
        if (!(portDuplicates = CollectionUtils.findDuplicateValues(this.ports)).isEmpty()) {
            Map.Entry duplicate = portDuplicates.entrySet().iterator().next();
            throw new BoxfuseException("Multiple ports defined for " + duplicate.getKey() + ": " + StringUtils.collectionToDelimitedString((Collection)((Collection)duplicate.getValue()), (String)", "));
        }
    }

    private void configurePayloadPort() {
        try {
            if (this.config.payload.port.isSet()) {
                this.setPayloadPort(this.config.payload.port.get());
            }
        }
        catch (BoxfuseException e) {
            throw new BoxfuseException("Invalid payload port name: " + e.getMessage());
        }
    }

    private void configureHealthcheckPort() {
        try {
            if (this.config.healthcheck.port.isSet()) {
                this.setHealthcheckPort(this.config.healthcheck.port.get());
            }
        }
        catch (BoxfuseException e) {
            throw new BoxfuseException("Invalid healthcheck port name: " + e.getMessage());
        }
    }

    @Override
    public ImageCoordinates getCoordinates() {
        return this.imageCoordinates;
    }

    public void setCoordinates(ImageCoordinates imageCoordinates) {
        this.imageCoordinates = imageCoordinates;
    }

    @Override
    public PlatformType[] getPlatforms() {
        return this.platforms;
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    @Override
    public Payload getPayload() {
        return this.payload;
    }

    @Override
    public Path getPayloadPath() {
        return this.payloadPath;
    }

    @Override
    public PortName getPayloadPort() {
        return this.payloadPort;
    }

    @Override
    public boolean isDebug() {
        return this.config.debug.enabled.get();
    }

    @Override
    public boolean isDebugWait() {
        return this.config.debug.wait.get();
    }

    @Override
    public Map<PortName, Port> getPorts() {
        return this.ports;
    }

    @Override
    public boolean isHealthcheck() {
        return this.healthcheck;
    }

    public void setHealthcheck(boolean healthcheck) {
        this.healthcheck = healthcheck;
    }

    @Override
    public PortName getHealthcheckPort() {
        return this.healthcheckPort;
    }

    @Override
    public Path getHealthcheckPath() {
        return this.healthcheckPath;
    }

    @Override
    public HealthcheckTimeout getHealthcheckTimeout() {
        return this.config.healthcheck.timeout.get();
    }

    @Override
    public Map<ComponentId, Version> getComponents() {
        return this.config.components;
    }

    @Override
    public JvmSpec getJvm() {
        return new AbstractJvmSpec(){

            @Override
            public String getJvmArgs() {
                return ((ImageSpecImpl)ImageSpecImpl.this).config.jvm.args.get();
            }

            @Override
            public String getMainClass() {
                return ((ImageSpecImpl)ImageSpecImpl.this).config.jvm.mainClass.get();
            }

            @Override
            public String getMainArgs() {
                return ((ImageSpecImpl)ImageSpecImpl.this).config.jvm.mainArgs.get();
            }

            @Override
            public boolean isJmx() {
                return ((ImageSpecImpl)ImageSpecImpl.this).config.jvm.jmx.get();
            }
        };
    }

    @Override
    public TmpGB getTmp() {
        return this.config.tmp.get();
    }

    public void validate() {
        if (this.appType == null) {
            throw new BoxfuseException("app.type has not been set");
        }
        if (this.dbType == null) {
            throw new BoxfuseException("db.type has not been set");
        }
        if (this.logsType == null) {
            throw new BoxfuseException("logs.type has not been set");
        }
        if (this.tlsType == null) {
            throw new BoxfuseException("tls.type has not been set");
        }
        this.validatePorts();
    }

    void validatePorts() {
        if (this.appType.isDns() && this.ports.isEmpty()) {
            throw new BoxfuseException("No ports defined, however " + this.appType + " apps require at least 1 port\n=> specify at least one port\n=> alternatively recreate your app as worker or one-off");
        }
        if (this.appType == AppType.LOAD_BALANCED || this.appType == AppType.LOAD_BALANCED_HTTPS) {
            for (Map.Entry<PortName, Port> entry : this.ports.entrySet()) {
                if (entry.getValue().getProtocol() != Protocol.UDP) continue;
                throw new BoxfuseException(this.appType.getName() + " apps do not support UDP ports, however the " + entry.getKey() + " port has been defined as " + entry.getValue() + "\n=> change the protocol of the port or recreate your app with a different app type");
            }
        }
        if (this.appType == AppType.LOAD_BALANCED_HTTPS && this.tlsType == TlsType.NONE) {
            for (Map.Entry<PortName, Port> entry : this.ports.entrySet()) {
                if (entry.getValue().getProtocol() != Protocol.HTTPS) continue;
                throw new BoxfuseException(this.appType.getName() + " apps do not support HTTPS ports when using tls.type=none, however the " + entry.getKey() + " port has been defined as " + entry.getValue() + "\n=> change the protocol of the port or recreate your app with a different app type");
            }
        }
    }

    @Override
    public boolean isStrace() {
        return this.config.strace.get();
    }

    public String toString() {
        return this.getPayload() + ", debug: " + this.isDebug() + ", ports: " + StringUtils.mapToDelimitedString(this.getPorts(), (String)", ");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageSpecImpl)) {
            return false;
        }
        ImageSpecImpl that = (ImageSpecImpl)o;
        return this.config.toMap().equals(that.config.toMap());
    }

    public int hashCode() {
        return this.config.toMap().hashCode();
    }

    public void setPayloadPath(Path path) {
        this.payloadPath = path;
    }

    public void setPayloadPort(PortName port) {
        this.payloadPort = port;
    }

    public void setHealthcheckPath(Path path) {
        this.healthcheckPath = path;
    }

    public void setHealthcheckPort(PortName healthcheckPort) {
        this.healthcheckPort = healthcheckPort;
    }

    @Override
    public AppType getAppType() {
        return this.appType;
    }

    public void setAppType(AppType appType) {
        this.appType = appType;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public LogsType getLogsType() {
        return this.logsType;
    }

    public void setLogsType(LogsType logsType) {
        this.logsType = logsType;
    }

    public TlsType getTlsType() {
        return this.tlsType;
    }

    public void setTlsType(TlsType tlsType) {
        this.tlsType = tlsType;
    }

    public Map<EnvVarName, EnvVarValue> getEnvVars() {
        return this.envVars;
    }

    public void setNewRelicLicenseKey(NewRelicLicenseKey newRelicLicenseKey) {
        this.newRelicLicenseKey = newRelicLicenseKey;
    }

    @Override
    public String getLinuxArgs() {
        return this.config.linuxArgs.get();
    }

    public String getCmd() {
        return this.config.cmd.get();
    }
}

