/*
 * Decompiled with CFR 0.152.
 */
package com.boxfuse.generator.newrelic;

import com.boxfuse.base.exception.BoxfuseException;

public class NewRelicLicenseKey {
    private final String licenseKey;

    public static NewRelicLicenseKey of(String licenseKey) {
        if (licenseKey == null) {
            return null;
        }
        return new NewRelicLicenseKey(licenseKey);
    }

    public NewRelicLicenseKey(String licenseKey) {
        if (!licenseKey.matches("[0-9a-zA-Z]{40,100}")) {
            throw new BoxfuseException("Invalid NewRelic license key: " + licenseKey + " => ensure it is at least 40 chars long and only contains a-f (lowercase) and 0-9");
        }
        this.licenseKey = licenseKey;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewRelicLicenseKey that = (NewRelicLicenseKey)o;
        return this.licenseKey.equals(that.licenseKey);
    }

    public int hashCode() {
        return this.licenseKey.hashCode();
    }

    public String toString() {
        return this.licenseKey;
    }
}

