@Echo off

setlocal

@REM Save install directory
set INSTALL_DIR=%~dp0

if exist "%INSTALL_DIR%upgrade\" (
  echo Backuping old version ...
  rmdir "%INSTALL_DIR%old" /s /q 2>nul
  mkdir "%INSTALL_DIR%old"
  move "%INSTALL_DIR%lib\*" "%INSTALL_DIR%old\" >nul
  echo Upgrading ...
  move /Y "%INSTALL_DIR%upgrade\boxfuse\lib\*" "%INSTALL_DIR%lib\" >nul
  move /Y "%INSTALL_DIR%upgrade\boxfuse\*.txt" "%INSTALL_DIR%" >nul
  rmdir "%INSTALL_DIR%upgrade" /s /q 2>nul
  echo Upgrade complete.
  echo.
)

if exist "%INSTALL_DIR%jre\bin\java.exe" (
  set JAVA_CMD="%INSTALL_DIR%jre\bin\java.exe"
) else (
  @REM Use JAVA_HOME if it is set
  if "%JAVA_HOME%"=="" (
    set JAVA_CMD=java
  ) else (
    set JAVA_CMD="%JAVA_HOME%\bin\java.exe"
  )
)

%JAVA_CMD% -version >nul 2>nul && (
  %JAVA_CMD% -Xmx2048m -Dfile.encoding=UTF-8 -cp "%INSTALL_DIR%lib\*" com.boxfuse.client.commandline.Main %*

  @REM Exit using the same code returned from Java
  EXIT /B %ERRORLEVEL%
) || (
  echo Boxfuse requires a Java Runtime Environment to be installed on your machine. Download the latest version from http://www.oracle.com/technetwork/java/javase/downloads/index.html or use an OS-specific Boxfuse Commandline Client distribution
  EXIT /B -1
)
